// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "CheckTr.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_GETSPECK, OnGetspeck)
	ON_COMMAND(ID_VIEW_CHARTBAR, OnViewChartbar)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	this->m_wndToolBar.SetWindowText(_T("Standard"));

	// Create the chart dialog bar
	if( !m_wndChartBar.Create(this, IDD_CHART_BAR, TBSTYLE_FLAT | WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC, IDD_CHART_BAR) )
	{
		TRACE0("Failed to create the chart bar\n");
		return -1;      // fail to create
	}
	this->m_wndChartBar.SetWindowText(_T("Chart Bar"));


	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	// Because of the presence of its edit boxes, allow the dialog bar
	// to be positioned only to the top or to the bottom of the frame
	m_wndChartBar.EnableDocking(CBRS_ALIGN_TOP | CBRS_ALIGN_BOTTOM);

	EnableDocking(CBRS_ALIGN_ANY);

	DockControlBar(&m_wndToolBar);
	DockControlBar(&m_wndChartBar);

		// Before performing an operation on the text boxes, get a pointer to each
	CEdit *pEditExposure    = reinterpret_cast<CEdit *>(this->m_wndChartBar.GetDlgItem(IDC_EXPOS));
	CEdit *pEditAverage   = reinterpret_cast<CEdit *>(this->m_wndChartBar.GetDlgItem(IDC_AVEDIT));
	CEdit *pEditBoxCar    = reinterpret_cast<CEdit *>(this->m_wndChartBar.GetDlgItem(IDC_BOXCAR));
	CButton *pCheckFast   = reinterpret_cast<CButton *>(this->m_wndChartBar.GetDlgItem(IDC_FAST));
	CButton *pCheckAverage   = reinterpret_cast<CButton *>(this->m_wndChartBar.GetDlgItem(IDC_AVERAGING));
	CButton *pCheckLog   = reinterpret_cast<CButton *>(this->m_wndChartBar.GetDlgItem(IDC_LOG));
	CButton *pSbstrBck   = reinterpret_cast<CButton *>(this->m_wndChartBar.GetDlgItem(IDC_SBSTRBCK));
	CButton *pRun   = reinterpret_cast<CButton *>(this->m_wndChartBar.GetDlgItem(IDC_RUN));
	CButton *pAutoY   = reinterpret_cast<CButton *>(this->m_wndChartBar.GetDlgItem(IDC_AUTOY));
	CStatic *pExpText    = reinterpret_cast<CStatic *>(this->m_wndChartBar.GetDlgItem(IDC_EXPTEXT));

	CButton *pRef_min_Spec    = reinterpret_cast<CButton *>(this->m_wndChartBar.GetDlgItem(IDC_RAD_REF_M_SP));
	CButton *pSpec_dev_Ref    = reinterpret_cast<CButton *>(this->m_wndChartBar.GetDlgItem(IDC_RAD_SP_DEV_REF));
	CButton *pLog1   = reinterpret_cast<CButton *>(this->m_wndChartBar.GetDlgItem(IDC_RAD_LOG1));
	CButton *pXYSpace    = reinterpret_cast<CButton *>(this->m_wndChartBar.GetDlgItem(IDC_XYSPACE));
	CProgressCtrl *pProgressBar1= reinterpret_cast<CProgressCtrl *>(this->m_wndChartBar.GetDlgItem(IDC_PROGRESS1));
	pProgressBar1->SetPos(0);

	// Set some initial values in the edit boxes
	pEditExposure->SetWindowText(_T("10"));
	pEditAverage->SetWindowText(_T("1"));
	pExpText->SetWindowText(_T("10"));
	pEditBoxCar->SetWindowText(_T("0"));

	pCheckFast->SetCheck(0);
	pAutoY->SetCheck(0);
	pCheckAverage->SetCheck(1);
	pCheckLog->SetCheck(0);

	pSbstrBck->SetCheck(0);
	pSbstrBck->EnableWindow(false);
	pRun->SetCheck(0);
	pRun->EnableWindow(false);
	pXYSpace->SetCheck(0);
	pXYSpace->EnableWindow(false);

	pRef_min_Spec->SetCheck(0);
	pRef_min_Spec->EnableWindow(false);
	pSpec_dev_Ref->SetCheck(0);
	pSpec_dev_Ref->EnableWindow(false);
	pLog1->SetCheck(0);
	pLog1->EnableWindow(false);

	
	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	cs.style &= ~FWS_ADDTOTITLE;

	cs.cx = 800;
	cs.cy = 600;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers


void CMainFrame::OnGetspeck() 
{
	// TODO: Add your command handler code here
	
}

void CMainFrame::OnViewChartbar() 
{
	// TODO: Add your command handler code here
	CMenu *m_pMenu = this->GetMenu();

	if(m_pMenu->GetMenuState(ID_VIEW_CHARTBAR, MF_CHECKED) )
	{
		ShowControlBar(&this->m_wndChartBar, FALSE, FALSE);
		m_pMenu->CheckMenuItem(ID_VIEW_CHARTBAR, MF_UNCHECKED);
	}
	else
	{
		ShowControlBar(&this->m_wndChartBar, TRUE, TRUE);
		m_pMenu->CheckMenuItem(ID_VIEW_CHARTBAR, MF_CHECKED);
	}
}
